/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cmsc420project4;

import java.util.ArrayList;

/**
 *
 * @author Jeremiah
 */
public class DirectedNode<T> {
    private ArrayList<DirectedNode> inNodes;
    private int inDegree;
    private T data;

    // Temporary number used for topological sort.
    private int topoNum;

//    DirectedNode()
//            {
//        inNodes = new ArrayList<DirectedNode>();
//        inDegree = 0;
//        data = null;
//    }

    DirectedNode(T data)
            {
        inNodes = new ArrayList<DirectedNode>();
        inDegree = 0;
        this.data = data;
    }

    public void addInNode(DirectedNode node)
            {
        // Only add it if it's not already in the graph - we don't support having multiple copies of the same node in the graph.
        if(inNodes.indexOf(node)==-1)
        {
            inNodes.add(node);
            inDegree += 1;
            topoNum = inDegree;
        }
    }

    /**
     * Returns whether or not node is an in-node of current node.
     * @param node
     * @return
     */
    public boolean isIn(DirectedNode node)
            {
        return inNodes.contains(node);
    }

    public int getInDegree()
            {
        System.out.println("InDegree = " + inDegree);
        return inDegree;
    }

    public void setData(T data)
            {
        this.data = data;
    }

    public T getData()
            {
        return data;
    }

    public ArrayList<DirectedNode> getInNodes()
            {
        return inNodes;
    }

    public void removeInNode(DirectedNode node)
            {
        inNodes.remove(node);
        inDegree-=1;
        topoNum = inDegree;
    }

    public int getTopoNum()
            {
        return topoNum;
    }

    public void setTopoNum(int num)
            {
        topoNum = num;
    }

    public void resetTopoNum()
            {
        topoNum = inDegree;
    }

    public void decrementTopoNum()
            {
        topoNum = topoNum - 1;
    }

}
